<?php
/**
 * Plugin Name: SpamKiller
 * Plugin URI: https://spamkiller.io
 * Description: AI-powered spam detection for WordPress forms. Protect contact forms, comments, registrations, and WooCommerce with advanced Gemini AI technology.
 * Version: 1.1.0
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * Author: SpamKiller
 * Author URI: https://spamkiller.io
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: spam-analyzer
 * Domain Path: /languages
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Plugin version
define('SPAM_ANALYZER_VERSION', '1.1.0');

// Plugin directory path
define('SPAM_ANALYZER_PLUGIN_DIR', plugin_dir_path(__FILE__));

// Plugin directory URL
define('SPAM_ANALYZER_PLUGIN_URL', plugin_dir_url(__FILE__));

// Plugin basename
define('SPAM_ANALYZER_BASENAME', plugin_basename(__FILE__));

/**
 * The code that runs during plugin activation
 */
function activate_spam_analyzer()
{
    require_once SPAM_ANALYZER_PLUGIN_DIR . 'includes/class-spam-analyzer-activator.php';
    Spam_Analyzer_Activator::activate();
}

/**
 * The code that runs during plugin deactivation
 */
function deactivate_spam_analyzer()
{
    require_once SPAM_ANALYZER_PLUGIN_DIR . 'includes/class-spam-analyzer-deactivator.php';
    Spam_Analyzer_Deactivator::deactivate();
}

register_activation_hook(__FILE__, 'activate_spam_analyzer');
register_deactivation_hook(__FILE__, 'deactivate_spam_analyzer');

/**
 * The core plugin class
 */
require SPAM_ANALYZER_PLUGIN_DIR . 'includes/class-spam-analyzer.php';

/**
 * Begins execution of the plugin
 */
function run_spam_analyzer()
{
    $plugin = new Spam_Analyzer();
    $plugin->run();
}

run_spam_analyzer();
