<?php
/**
 * WPForms Integration
 */
class Spam_Analyzer_WPForms
{
    /**
     * Validate WPForms submission
     */
    public function validate_submission($fields, $entry)
    {
        if (!get_option('spam_analyzer_enable_wpforms')) {
            return $fields;
        }

        $email = '';
        $body = array();

        foreach ($fields as $field) {
            $value = !empty($field['value']) ? $field['value'] : '';

            if (empty($value)) {
                continue;
            }

            // Track email separately (required)
            if ($field['type'] === 'email') {
                $email = $value;
                // Don't add email to body
                continue;
            }

            // Add all other fields to body as key-value pairs
            $body[$field['name']] = $value;
        }

        // Email is required - skip validation if not found
        if (empty($email)) {
            return $fields; // No email found, cannot validate
        }

        // Validate with API
        $result = Spam_Analyzer_Validator::validate(
            array(
                'context' => 'WPForms submission on WordPress website',
                'email' => $email,
                'body' => $body,  // Now an object (associative array)
            ),
            'wpforms',
            $entry['id'],
            $email
        );

        if (Spam_Analyzer_Validator::should_block($result)) {
            wpforms()->process->errors[$entry['id']]['header'] = __('Your submission has been identified as spam.', 'spam-analyzer');
        }

        return $fields;
    }
}
