<?php
/**
 * User Registration Integration
 */
class Spam_Analyzer_Registration
{
    /**
     * Validate user registration
     */
    public function validate_registration($errors, $sanitized_user_login, $user_email)
    {
        if (!get_option('spam_analyzer_enable_registration')) {
            return $errors;
        }

        // Validate with API
        $result = Spam_Analyzer_Validator::validate(
            array(
                'context' => 'User registration on WordPress website',
                'email' => $user_email,
                'body' => array(
                    'username' => $sanitized_user_login,
                ),  // Now an object (associative array)
            ),
            'user_registration',
            null,
            $user_email
        );

        if (Spam_Analyzer_Validator::should_block($result)) {
            $errors->add(
                'spam_registration',
                __('<strong>ERROR</strong>: Registration failed. Please contact the site administrator.', 'spam-analyzer')
            );
        }

        return $errors;
    }
}
