<?php
/**
 * Gravity Forms Integration
 */
class Spam_Analyzer_Gravity_Forms
{
    /**
     * Validate Gravity Forms submission
     */
    public function validate_submission($validation_result)
    {
        if (!get_option('spam_analyzer_enable_gf')) {
            return $validation_result;
        }

        $form = $validation_result['form'];

        $email = '';
        $body = array();

        foreach ($form['fields'] as $field) {
            $value = rgpost("input_{$field->id}");

            if (empty($value)) {
                continue;
            }

            // Track email separately (required)
            if ($field->type === 'email') {
                $email = $value;
                // Don't add email to body
                continue;
            }

            // Add all other fields to body as key-value pairs
            $body[$field->label] = $value;
        }

        // Email is required - skip validation if not found
        if (empty($email)) {
            return $validation_result; // No email found, cannot validate
        }

        // Validate with API
        $result = Spam_Analyzer_Validator::validate(
            array(
                'context' => 'Gravity Forms submission on WordPress website',
                'email' => $email,
                'body' => $body,  // Now an object (associative array)
            ),
            'gravity_forms',
            $form['id'],
            $email
        );

        if (Spam_Analyzer_Validator::should_block($result)) {
            $validation_result['is_valid'] = false;

            foreach ($form['fields'] as &$field) {
                if ($field->type === 'email') {
                    $field->failed_validation = true;
                    $field->validation_message = __('Your submission has been identified as spam.', 'spam-analyzer');
                    break;
                }
            }
        }

        return $validation_result;
    }
}
