<?php
/**
 * Contact Form 7 Integration
 */
class Spam_Analyzer_Contact_Form_7
{
    /**
     * Validate CF7 submission
     */
    public function validate_submission($result, $tag)
    {
        if (!get_option('spam_analyzer_enable_cf7')) {
            return $result;
        }

        $submission = WPCF7_Submission::get_instance();

        if (!$submission) {
            return $result;
        }

        $data = $submission->get_posted_data();

        // Extract email (required) and build body object
        $email = '';
        $body = array();

        foreach ($data as $key => $value) {
            if (is_array($value)) {
                $value = implode(', ', $value);
            }

            // Track email separately (required)
            if (strpos($key, 'email') !== false && is_email($value)) {
                $email = $value;
                // Don't add email to body
                continue;
            }

            // Add all other fields to body as key-value pairs
            $body[$key] = $value;
        }

        // Email is required - skip validation if not found
        if (empty($email)) {
            return $result; // No email found, cannot validate
        }

        // Validate with API
        $validation_result = Spam_Analyzer_Validator::validate(
            array(
                'context' => 'Contact Form 7 submission on WordPress website',
                'email' => $email,
                'body' => $body,  // Now an object (associative array)
            ),
            'contact_form_7',
            null,
            $email
        );

        if (Spam_Analyzer_Validator::should_block($validation_result)) {
            $result->invalidate('', __('Your submission has been identified as spam and cannot be sent.', 'spam-analyzer'));
        }

        return $result;
    }
}
