<?php
/**
 * WordPress Comments Integration
 */
class Spam_Analyzer_Comments
{
    /**
     * Validate comment submission
     */
    public function validate_comment($commentdata)
    {
        if (!get_option('spam_analyzer_enable_comments')) {
            return $commentdata;
        }

        // Skip for logged-in admins
        if (current_user_can('moderate_comments')) {
            return $commentdata;
        }

        $email = $commentdata['comment_author_email'];

        // Validate with API
        $result = Spam_Analyzer_Validator::validate(
            array(
                'context' => 'Blog comment on WordPress website',
                'email' => $email,
                'body' => array(
                    'comment' => $commentdata['comment_content'],
                    'author' => $commentdata['comment_author'],
                    'url' => $commentdata['comment_author_url'],
                ),  // Now an object (associative array)
            ),
            'wordpress_comment',
            null,
            $email
        );

        if (Spam_Analyzer_Validator::should_block($result)) {
            wp_die(
                __('Your comment has been identified as spam and cannot be posted.', 'spam-analyzer'),
                __('Comment Blocked', 'spam-analyzer'),
                array('response' => 403, 'back_link' => true)
            );
        }

        return $commentdata;
    }
}
