<?php
/**
 * Fired during plugin activation
 */
class Spam_Analyzer_Activator
{
    public static function activate()
    {
        global $wpdb;

        $table_name = $wpdb->prefix . 'spam_analyzer_logs';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE IF NOT EXISTS $table_name (
            id bigint(20) NOT NULL AUTO_INCREMENT,
            type varchar(50) NOT NULL,
            entity_id bigint(20) DEFAULT NULL,
            is_spam tinyint(1) NOT NULL,
            spam_score decimal(5,2) NOT NULL,
            confidence decimal(5,2) NOT NULL,
            ip_address varchar(45) DEFAULT NULL,
            email varchar(255) DEFAULT NULL,
            blocked tinyint(1) NOT NULL DEFAULT 0,
            validation_data longtext,
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY  (id),
            KEY type (type),
            KEY created_at (created_at),
            KEY is_spam (is_spam)
        ) $charset_collate;";

        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);

        // Set default options
        add_option('spam_analyzer_api_key', '');
        add_option('spam_analyzer_threshold', 70);
        add_option('spam_analyzer_enable_cf7', 1);
        add_option('spam_analyzer_enable_gf', 1);
        add_option('spam_analyzer_enable_wpforms', 1);
        add_option('spam_analyzer_enable_comments', 1);
        add_option('spam_analyzer_enable_registration', 1);
        add_option('spam_analyzer_block_mode', 'block');
        add_option('spam_analyzer_log_activity', 0);
        add_option('spam_analyzer_version', SPAM_ANALYZER_VERSION);
    }
}
