<?php
/**
 * Admin page display
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

// Save settings
if (isset($_POST['spam_analyzer_save_settings']) && check_admin_referer('spam_analyzer_settings')) {
    update_option('spam_analyzer_api_key', sanitize_text_field($_POST['spam_analyzer_api_key']));
    update_option('spam_analyzer_threshold', absint($_POST['spam_analyzer_threshold']));
    update_option('spam_analyzer_enable_cf7', isset($_POST['spam_analyzer_enable_cf7']) ? 1 : 0);
    update_option('spam_analyzer_enable_gf', isset($_POST['spam_analyzer_enable_gf']) ? 1 : 0);
    update_option('spam_analyzer_enable_wpforms', isset($_POST['spam_analyzer_enable_wpforms']) ? 1 : 0);
    update_option('spam_analyzer_enable_comments', isset($_POST['spam_analyzer_enable_comments']) ? 1 : 0);
    update_option('spam_analyzer_enable_registration', isset($_POST['spam_analyzer_enable_registration']) ? 1 : 0);
    update_option('spam_analyzer_enable_woocommerce', isset($_POST['spam_analyzer_enable_woocommerce']) ? 1 : 0);
    update_option('spam_analyzer_enable_woocommerce_reviews', isset($_POST['spam_analyzer_enable_woocommerce_reviews']) ? 1 : 0);
    update_option('spam_analyzer_enable_woocommerce_registration', isset($_POST['spam_analyzer_enable_woocommerce_registration']) ? 1 : 0);
    update_option('spam_analyzer_block_mode', sanitize_text_field($_POST['spam_analyzer_block_mode']));
    update_option('spam_analyzer_log_activity', isset($_POST['spam_analyzer_log_activity']) ? 1 : 0);

    echo '<div class="notice notice-success"><p>' . __('Settings saved successfully!', 'spam-analyzer') . '</p></div>';
}

// Get current settings
$api_key = get_option('spam_analyzer_api_key');
$threshold = get_option('spam_analyzer_threshold', 70);
$enable_cf7 = get_option('spam_analyzer_enable_cf7', 1);
$enable_gf = get_option('spam_analyzer_enable_gf', 1);
$enable_wpforms = get_option('spam_analyzer_enable_wpforms', 1);
$enable_comments = get_option('spam_analyzer_enable_comments', 1);
$enable_registration = get_option('spam_analyzer_enable_registration', 1);
$enable_woocommerce = get_option('spam_analyzer_enable_woocommerce', 1);
$enable_woocommerce_reviews = get_option('spam_analyzer_enable_woocommerce_reviews', 1);
$enable_woocommerce_registration = get_option('spam_analyzer_enable_woocommerce_registration', 1);
$block_mode = get_option('spam_analyzer_block_mode', 'block');
$log_activity = get_option('spam_analyzer_log_activity', 0);

// Check API connection
$api_status = null;
if (!empty($api_key)) {
    try {
        $api = new Spam_Analyzer_API($api_key);
        $api_status = $api->get_status();
    } catch (Exception $e) {
        $api_error = $e->getMessage();
    }
}

// Get statistics
$stats = Spam_Analyzer_Validator::get_statistics(30);
?>

<div class="wrap spam-analyzer-admin">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <!-- API Status -->
    <?php if (!empty($api_key)): ?>
        <?php if ($api_status): ?>
            <div class="notice notice-success">
                <h3><?php _e('✓ API Connection Active', 'spam-analyzer'); ?></h3>
                <p>
                    <strong><?php _e('Project:', 'spam-analyzer'); ?></strong> <?php echo esc_html($api_status['data']['project']['name']); ?><br>
                    <strong><?php _e('Plan:', 'spam-analyzer'); ?></strong> <?php echo esc_html($api_status['data']['subscription']['plan']['name']); ?><br>
                    <strong><?php _e('Validations Used:', 'spam-analyzer'); ?></strong> <?php echo number_format($api_status['data']['subscription']['usage']['validations_used']); ?> /
                    <?php echo number_format($api_status['data']['subscription']['usage']['validations_limit']); ?>
                    (<?php echo $api_status['data']['subscription']['usage']['usage_percentage']; ?>%)
                </p>
            </div>
        <?php else: ?>
            <div class="notice notice-error">
                <h3><?php _e('✗ API Connection Failed', 'spam-analyzer'); ?></h3>
                <p><?php echo esc_html($api_error); ?></p>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="notice notice-warning">
            <h3><?php _e('⚠ API Key Not Configured', 'spam-analyzer'); ?></h3>
            <p><?php _e('Please enter your SpamKiller API key below to start protecting your WordPress site.', 'spam-analyzer'); ?></p>
            <p><a href="https://spamkiller.io/register" target="_blank" class="button button-primary"><?php _e('Get Free API Key', 'spam-analyzer'); ?></a></p>
        </div>
    <?php endif; ?>

    <!-- Statistics -->
    <div class="card">
        <h2><?php _e('Statistics (Last 30 Days)', 'spam-analyzer'); ?></h2>
        <div class="stats-grid">
            <div class="stat-box">
                <div class="stat-number"><?php echo number_format($stats['total']); ?></div>
                <div class="stat-label"><?php _e('Total Validations', 'spam-analyzer'); ?></div>
            </div>
            <div class="stat-box stat-danger">
                <div class="stat-number"><?php echo number_format($stats['spam']); ?></div>
                <div class="stat-label"><?php _e('Spam Detected', 'spam-analyzer'); ?></div>
            </div>
            <div class="stat-box stat-success">
                <div class="stat-number"><?php echo number_format($stats['legitimate']); ?></div>
                <div class="stat-label"><?php _e('Legitimate', 'spam-analyzer'); ?></div>
            </div>
            <div class="stat-box stat-warning">
                <div class="stat-number"><?php echo number_format($stats['blocked']); ?></div>
                <div class="stat-label"><?php _e('Blocked', 'spam-analyzer'); ?></div>
            </div>
        </div>
    </div>

    <!-- Settings Form -->
    <form method="post" action="">
        <?php wp_nonce_field('spam_analyzer_settings'); ?>

        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="spam_analyzer_api_key"><?php _e('API Key', 'spam-analyzer'); ?> <span class="required">*</span></label>
                </th>
                <td>
                    <input type="text" id="spam_analyzer_api_key" name="spam_analyzer_api_key"
                           value="<?php echo esc_attr($api_key); ?>" class="regular-text" required>
                    <p class="description">
                        <?php _e('Enter your SpamKiller API key. Get it from', 'spam-analyzer'); ?>
                        <a href="https://spamkiller.io/dashboard" target="_blank">spamkiller.io</a>
                    </p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="spam_analyzer_threshold"><?php _e('Spam Threshold', 'spam-analyzer'); ?></label>
                </th>
                <td>
                    <input type="number" id="spam_analyzer_threshold" name="spam_analyzer_threshold"
                           value="<?php echo esc_attr($threshold); ?>" min="0" max="100" step="1" class="small-text">
                    <p class="description"><?php _e('Score above which content is considered spam (0-100). Recommended: 70', 'spam-analyzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php _e('Enable Protection For:', 'spam-analyzer'); ?></th>
                <td>
                    <?php if (class_exists('WPCF7')): ?>
                        <label>
                            <input type="checkbox" name="spam_analyzer_enable_cf7" value="1" <?php checked($enable_cf7, 1); ?>>
                            <?php _e('Contact Form 7', 'spam-analyzer'); ?>
                        </label><br>
                    <?php endif; ?>

                    <?php if (class_exists('GFForms')): ?>
                        <label>
                            <input type="checkbox" name="spam_analyzer_enable_gf" value="1" <?php checked($enable_gf, 1); ?>>
                            <?php _e('Gravity Forms', 'spam-analyzer'); ?>
                        </label><br>
                    <?php endif; ?>

                    <?php if (function_exists('wpforms')): ?>
                        <label>
                            <input type="checkbox" name="spam_analyzer_enable_wpforms" value="1" <?php checked($enable_wpforms, 1); ?>>
                            <?php _e('WPForms', 'spam-analyzer'); ?>
                        </label><br>
                    <?php endif; ?>

                    <label>
                        <input type="checkbox" name="spam_analyzer_enable_comments" value="1" <?php checked($enable_comments, 1); ?>>
                        <?php _e('WordPress Comments', 'spam-analyzer'); ?>
                    </label><br>

                    <label>
                        <input type="checkbox" name="spam_analyzer_enable_registration" value="1" <?php checked($enable_registration, 1); ?>>
                        <?php _e('User Registration', 'spam-analyzer'); ?>
                    </label><br>

                    <?php if (class_exists('WooCommerce')): ?>
                        <br>
                        <strong><?php _e('WooCommerce:', 'spam-analyzer'); ?></strong><br>
                        <label style="margin-left: 20px;">
                            <input type="checkbox" name="spam_analyzer_enable_woocommerce" value="1" <?php checked($enable_woocommerce, 1); ?>>
                            <?php _e('Checkout Protection', 'spam-analyzer'); ?>
                        </label><br>
                        <label style="margin-left: 20px;">
                            <input type="checkbox" name="spam_analyzer_enable_woocommerce_reviews" value="1" <?php checked($enable_woocommerce_reviews, 1); ?>>
                            <?php _e('Product Reviews', 'spam-analyzer'); ?>
                        </label><br>
                        <label style="margin-left: 20px;">
                            <input type="checkbox" name="spam_analyzer_enable_woocommerce_registration" value="1" <?php checked($enable_woocommerce_registration, 1); ?>>
                            <?php _e('Registration During Checkout', 'spam-analyzer'); ?>
                        </label>
                    <?php endif; ?>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="spam_analyzer_block_mode"><?php _e('Block Mode', 'spam-analyzer'); ?></label>
                </th>
                <td>
                    <select id="spam_analyzer_block_mode" name="spam_analyzer_block_mode">
                        <option value="block" <?php selected($block_mode, 'block'); ?>><?php _e('Block spam submissions', 'spam-analyzer'); ?></option>
                        <option value="log" <?php selected($block_mode, 'log'); ?>><?php _e('Log only (allow but record)', 'spam-analyzer'); ?></option>
                    </select>
                    <p class="description"><?php _e('Choose how to handle spam detections', 'spam-analyzer'); ?></p>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="spam_analyzer_log_activity"><?php _e('Activity Logging', 'spam-analyzer'); ?></label>
                </th>
                <td>
                    <label>
                        <input type="checkbox" id="spam_analyzer_log_activity" name="spam_analyzer_log_activity" value="1" <?php checked($log_activity, 1); ?>>
                        <?php _e('Log validations to WordPress error log', 'spam-analyzer'); ?>
                    </label>
                </td>
            </tr>
        </table>

        <?php submit_button(__('Save Settings', 'spam-analyzer'), 'primary', 'spam_analyzer_save_settings'); ?>
    </form>
</div>
